 <?php
/**
 * Plugin Name: Featured Image from ACF field
 * Version: 1.0
 * Description:  The featured image of the post is feed by the ACF Field 'image_spectacle' 
 * Author: Mraj 
 * Author URI: https://www.softaox.info/advanced-custom-fields-set-image-field-as-post-featured-image/
 */
  
add_action('acf/save_post', function ($post_id) {
    $value = get_field('image_spectacle', $post_id);
    if ($value) {
        if (!is_numeric($value)) {
            $value = $value['ID'];
        }
        update_post_meta($post_id, '_thumbnail_id', $value);
    } else {
        delete_post_meta($post_id, '_thumbnail_id');
    }
}, 11);


